/*-------------------------------------------------------*
*  Name:      Import.cpp                                 *
*  Purpose:   XO files import ode                       *
*  Authors:   Oleg M.                                    *
*  History:   10.Oct.2002 - started                      *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <3DEngine.h>

#include "xo.h"



/**********************************************************************/
//        Importer
/**********************************************************************/
DWORD CALLBACK Import(
                CString fromfile,
                CWnd *pwnd,
                tObjectSet* Objects,
                tUnDataSet* UnData,
                CDirect3D*  d3d,
                SYSTEMREQUESTPROC RequestProc,
                HINSTANCE AppHIns,
                HINSTANCE DllHIns)
{
  CFile file;
  if (!file.Open(fromfile, CFile::modeRead))
    return ShowFailMessage(pwnd, "Can't open file", "interlocked or share violation", MB_ICONHAND);

  char filename[256];
  strcpy(filename, (LPCSTR)file.GetFileTitle());

  char* pdot = strrchr(filename, '.');
  if (pdot)
    *pdot = '\0';
  DEBUG_OPEN()
  
  xoFileHeader  Header;
  file.Read(&Header, sizeof(Header));
  //dump
  DEBUG_MESSAGE4("Importing from file %s\n"
                 "  ID: 0x%X, Unks: %li, %li\n",
                 (LPCSTR)fromfile, Header.m_dwID,
                 Header.m_Unk1, Header.m_Unk2);
  DEBUG_MESSAGE4(" {%f, %f, %f, %f}\n",
                 Header.m_fUnks[0], Header.m_fUnks[1], Header.m_fUnks[2], Header.m_fUnks[3]);
  DEBUG_MESSAGE3(" Faces: %li\tStart: %X\tsize: %X\n",
                 Header.m_numFaces, Header.m_FacesStart, Header.m_FacesBlockSize);
  DEBUG_MESSAGE3(" Vertices: %li\tStart: %X\tsize: %X\n",
                 Header.m_numVerts, Header.m_VertsStart, Header.m_VertsBlockSize);
  DEBUG_MESSAGE3(" Normals: %li\tStart: %X\tsize: %X\n",
                 Header.m_numNorms, Header.m_NormsStart, Header.m_NormsBlockSize);
  DEBUG_MESSAGE3(" Textures: %li\tStart: %X\tsize: %X\n",
                 Header.m_numTex, Header.m_TexStart, Header.m_TexBlockSize);

  xoFace* pFaces = new xoFace[Header.m_numFaces];
  tPOINT* pVerts = new tPOINT[Header.m_numVerts];
  tPOINT* pNorms = new tPOINT[Header.m_numNorms];
  long*   pMatMap= new long  [Header.m_numTex];
  file.ReadHuge(pFaces, sizeof(xoFace)*Header.m_numFaces);
  file.ReadHuge(pVerts, sizeof(tPOINT)*Header.m_numVerts);
  file.ReadHuge(pNorms, sizeof(tPOINT)*Header.m_numNorms);
  //read strings
  char* pszTexturesBuf = new char[Header.m_TexBlockSize];
  char* pTextureName = pszTexturesBuf;
  file.ReadHuge(pszTexturesBuf, Header.m_TexBlockSize);
  
  if (file.GetPosition() + 8 <= file.GetLength())
  {//read locking info:
    DWORD dwLOCK[2];
    file.Read(dwLOCK, 8);
    if (dwLOCK[0] == XO_FILE_LOCK_ID)
      if (dwLOCK[1] == (DWORD)(XO_FILE_LOCK_SEED + Header.m_TexStart))
      {//locked
        delete[] pFaces;
        delete[] pVerts;
        delete[] pNorms;
        delete[] pMatMap;
        delete[] pszTexturesBuf;
        DEBUG_CLOSE()
        return Z3D_PLUGRESULT_REDRAW;
      }//locked
  }

 
  //
  // create textured materials
  //
  for (int tex = 0; tex < Header.m_numTex; tex++)
  {
    pMatMap[tex] = d3d->CreateMaterial( 1.0f, 1.0f, 1.0f, 1.0f,
                                        1.0f, 80.0f,
                                        pTextureName,
                                        NULL,
                                        "chrome.bmp",
                                        NULL,
                                        pTextureName,
                                        TEX_NAMEPATHMATCH_NOCASE | TEX_NAMEPATHMATCH_NAMEONLY,
                                        D3DTOP_MODULATE,
                                        D3DTOP_DISABLE,
                                        D3DTOP_ADD,
                                        D3DTOP_DISABLE,
                                        D3DBLEND_SRCALPHA,
                                        D3DBLEND_INVSRCALPHA,
                                        1);
    while (*pTextureName != '\0')
      pTextureName++;
    pTextureName++;
  }

  //
  // create matte materials
  //
  long numMatte = 0;
  for (int matte = 0; matte < Header.m_numFaces; matte++)
    if (pFaces[matte].m_nTexture == 0)
      numMatte++;
  long*   pColMap     = numMatte ? new long[Header.m_numFaces] : NULL;
  if (numMatte)
  {
    DWORD*   pUsedColors = new DWORD[numMatte];
    numMatte = 0;
    for (int matte = 0; matte < Header.m_numFaces; matte++)
      if (pFaces[matte].m_nTexture == 0)
      {
        for (int col = 0; col < numMatte; col++)
          //i use vertex#1 color only!
          if (pUsedColors[col] == pFaces[matte].m_VertColor[0])
            break;
        if (col == numMatte)
        {//new color
          DWORD color = pFaces[matte].m_VertColor[0];
          pUsedColors[numMatte++] = color;
          char colorname[32];
          sprintf(colorname, "Matte: 0x%.6X", pFaces[matte].m_VertColor[0]);
          pColMap[matte] = d3d->CreateMaterial(
                                          ((color & 0xFF0000)>>16)/256.0f,
                                          ((color & 0xFF00)>>8)/256.0f,
                                          ((color & 0xFF))/256.0f,
                                          ((color & 0xFF000000)>>24)/256.0f,
                                          1.0f, 80.0f,
                                          NULL,
                                          NULL,
                                          "chrome.bmp",
                                          NULL,
                                          colorname,
                                          TEX_NAMEPATHMATCH_NOCASE | TEX_NAMEPATHMATCH_NAMEONLY,
                                          D3DTOP_MODULATE,
                                          D3DTOP_DISABLE,
                                          D3DTOP_ADD,
                                          D3DTOP_DISABLE,
                                          D3DBLEND_SRCALPHA,
                                          D3DBLEND_INVSRCALPHA,
                                          1);//(pFaces[matte].nFlags & XO_FACE_ALPHABLEND) ? 1:0);
        }//new color
        else
          for (col = 0; col < matte; col++)
            if ((pFaces[col].m_nTexture == 0) &&
                (pFaces[matte].m_VertColor[0] == pFaces[col].m_VertColor[0]))
            {
              pColMap[matte] = pColMap[col];//old color
              break;
            }
      }
    delete[] pUsedColors;
  }//has matte


  //
  // :FIXME: we shall not bother with split of vertices using per-faces normals
  //

  tObject* pObj = new tObject(filename, Header.m_numVerts, Header.m_numFaces);
  for (int vert = 0; vert < Header.m_numVerts; vert++)
  {
    pObj->VertTable->Table[vert].X = -pVerts[vert].x;
    pObj->VertTable->Table[vert].Y = pVerts[vert].y;
    pObj->VertTable->Table[vert].Z = pVerts[vert].z;
    pObj->VertTable->Table[vert].NormalX = 0.0f;
    pObj->VertTable->Table[vert].NormalY = 0.0f;
    pObj->VertTable->Table[vert].NormalZ = 0.0f;
  }

  for (int face = 0; face < Header.m_numFaces; face++)
  {
    pObj->FaceTable->Table[face].I1 = pFaces[face].i1;
    pObj->FaceTable->Table[face].I2 = pFaces[face].i2;
    pObj->FaceTable->Table[face].I3 = pFaces[face].i3;

    pObj->FaceTable->Table[face].U1 = pFaces[face].m_UVs.u1;
    pObj->FaceTable->Table[face].U2 = pFaces[face].m_UVs.u2;
    pObj->FaceTable->Table[face].U3 = pFaces[face].m_UVs.u3;
    pObj->FaceTable->Table[face].V1 = 1.0f-pFaces[face].m_UVs.v1;
    pObj->FaceTable->Table[face].V2 = 1.0f-pFaces[face].m_UVs.v2;
    pObj->FaceTable->Table[face].V3 = 1.0f-pFaces[face].m_UVs.v3;
    if (0==pFaces[face].m_nTexture)
      pObj->FaceTable->Table[face].Material = pColMap[face];
    else
      pObj->FaceTable->Table[face].Material = pMatMap[pFaces[face].m_nTexture-1];
    if (0==(pFaces[face].nFlags & XO_FACE_CHROME))
      pObj->FaceTable->Table[face].nRenderFlags |= NoBlend;
    if (pFaces[face].nFlags & XO_FACE_SEMITRANS)
      pObj->FaceTable->Table[face].nRenderFlags |= SemiTransparent;

    pObj->VertTable->Table[pFaces[face].i1].NormalX +=-pNorms[pFaces[face].n1].x;
    pObj->VertTable->Table[pFaces[face].i1].NormalY += pNorms[pFaces[face].n1].y;
    pObj->VertTable->Table[pFaces[face].i1].NormalZ += pNorms[pFaces[face].n1].z;

    pObj->VertTable->Table[pFaces[face].i2].NormalX +=-pNorms[pFaces[face].n2].x;
    pObj->VertTable->Table[pFaces[face].i2].NormalY += pNorms[pFaces[face].n2].y;
    pObj->VertTable->Table[pFaces[face].i2].NormalZ += pNorms[pFaces[face].n2].z;

    pObj->VertTable->Table[pFaces[face].i3].NormalX +=-pNorms[pFaces[face].n3].x;
    pObj->VertTable->Table[pFaces[face].i3].NormalY += pNorms[pFaces[face].n3].y;
    pObj->VertTable->Table[pFaces[face].i3].NormalZ += pNorms[pFaces[face].n3].z;
    //DEBUG_MESSAGE2("{%f, %f}\n", pFaces[face].unk[0], pFaces[face].unk[1]);
  }
  pObj->VertTable->MarkAll();
  pObj->NormalizeNormals(TRUE, FALSE);
  pObj->VertTable->UnMarkAll();
  pObj->nRequire = Z3D_PLUGRESULT_REDRAW;
  file.Close();
//--------------------------------------------------------------
// Create damaged-partner.
//--------------------------------------------------------------
  CFile fileVert;
  CFile fileUV;
  //crop filename a bit...
  int len = strlen(filename);
  if (len > 3)
    if ((filename[len-3] == 'A') ||
        (filename[len-3] == 'a'))
      strcpy(&filename[len-3], &filename[len-2]);
  CString FileName = CString("../vertices/")+CString(filename);
  if (fileVert.Open(FileName+CString("_vertex.bin"), CFile::modeRead) && 
      fileUV.Open(FileName+CString("_uv.bin"), CFile::modeRead))
  {//there are damaged partners
    long scratches = d3d->CreateMaterial(1.0f, 1.0f, 1.0f, 1.0f,
                                        1.0f, 80.0f,
                                        "../common/map_demo.tga",
                                        NULL,
                                        NULL,
                                        NULL,
                                        "[damages overlay]",
                                        TEX_NAMEPATHMATCH_NOCASE | TEX_NAMEPATHMATCH_NAMEONLY,
                                        D3DTOP_MODULATE,
                                        D3DTOP_DISABLE,
                                        D3DTOP_DISABLE,
                                        D3DTOP_DISABLE,
                                        D3DBLEND_ONE,
                                        D3DBLEND_ZERO,
                                        0);

    xoUVs*  pUVs = new xoUVs[Header.m_numFaces];
    fileVert.ReadHuge(pVerts, sizeof(tPOINT)*Header.m_numVerts);
    fileUV.ReadHuge(pUVs, sizeof(xoUVs)*Header.m_numFaces);
    fileVert.Close();
    fileUV.Close();
    //create damaged partner:
    tObject* pDamObject = new tObject((char*)(LPCSTR)(CString(filename)+CString("[D]")), Header.m_numVerts, Header.m_numFaces);
    for (vert = 0; vert < Header.m_numVerts; vert++)
    {
      pDamObject->VertTable->Table[vert] = pObj->VertTable->Table[vert];
      pDamObject->VertTable->Table[vert].X = -pVerts[vert].x;
      pDamObject->VertTable->Table[vert].Y = pVerts[vert].y;
      pDamObject->VertTable->Table[vert].Z = pVerts[vert].z;
    }
    //
    //  :FIXME: Consider damaged textures
    //
    for (face = 0; face < Header.m_numFaces; face++)
    {
      pDamObject->FaceTable->Table[face] = pObj->FaceTable->Table[face];
      pDamObject->FaceTable->Table[face].Material = scratches;
      pDamObject->FaceTable->Table[face].U1= pUVs[face].u1;
      pDamObject->FaceTable->Table[face].V1= pUVs[face].v1;
      pDamObject->FaceTable->Table[face].U2= pUVs[face].u2;
      pDamObject->FaceTable->Table[face].V2= pUVs[face].v2;
      pDamObject->FaceTable->Table[face].U3= pUVs[face].u3;
      pDamObject->FaceTable->Table[face].V3= pUVs[face].v3;
    }
    delete[] pUVs;

    pDamObject->nRequire = Z3D_PLUGRESULT_REDRAW;
    pDamObject->Hide();
    Objects->AddObject(pDamObject);
    delete pDamObject;
  }//there are damaged partners
  Objects->AddObject(pObj);
  delete pObj;

  delete[] pFaces;
  delete[] pVerts;
  delete[] pNorms;
  delete[] pMatMap;
  delete[] pszTexturesBuf;

  if (pColMap)
    delete[] pColMap;

  DEBUG_CLOSE()
  return Z3D_PLUGRESULT_REDRAW;
}